/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.observable;

import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.Observer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.Exceptions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Action;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Supplier;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.fuseable.CancellableQueueFuseable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class ObservableFromAction<T>
extends Observable<T>
implements Supplier<T> {
    final Action action;

    public ObservableFromAction(Action action) {
        this.action = action;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        CancellableQueueFuseable qs = new CancellableQueueFuseable();
        observer.onSubscribe(qs);
        if (!qs.isDisposed()) {
            try {
                this.action.run();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                if (!qs.isDisposed()) {
                    observer.onError(ex);
                } else {
                    RxJavaPlugins.onError(ex);
                }
                return;
            }
            if (!qs.isDisposed()) {
                observer.onComplete();
            }
        }
    }

    @Override
    public T get() throws Throwable {
        this.action.run();
        return null;
    }
}

